﻿/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

namespace CSrfeReaderInterface.protocol
{
    /// <summary>
    /// Global constants given by RF-Embedded reader host protocol
    /// </summary>
    public static class Constants
    {
        /// <summary>Base index of the payload in package</summary>
        public const byte RFE_DATA_BASE_INDEX 			= 9;

        /// <summary>Index of the first start byte</summary>
        public const byte RFE_START_INDEX_1 = 0;
        /// <summary>Index of the second start byte</summary>
        public const byte RFE_START_INDEX_2 = 1;
        /// <summary>Index of the third start byte</summary>
        public const byte RFE_START_INDEX_3 = 2;
        /// <summary>Index of the command start byte</summary>
        public const byte RFE_COMMAND_START_INDEX = 3;
        /// <summary>Index of the first command</summary>
        public const byte RFE_COMMAND_INDEX_1 = 4;
        /// <summary>Index of the second command</summary>
        public const byte RFE_COMMAND_INDEX_2 = 5;
        /// <summary>Index of the length start byte</summary>
        public const byte RFE_LENGTH_START_INDEX = 6;
        /// <summary>Index of the length</summary>
        public const byte RFE_LENGTH_INDEX = 7;	

        /// <summary>Index of the payload start byte</summary>
        public const byte RFE_PAYLOAD_START_INDEX = 8;	
        /// <summary>Index of the payload</summary>
        public const byte RFE_PAYLOAD_INDEX = 9;	

        /// <summary>Index of the checksum start byte if no payload is in the package</summary>
        public const byte RFE_CS_START_WITHOUT_PAYLOAD = 8;	
        /// <summary>Index of the checksum if no payload is in the package</summary>
        public const byte RFE_CS_WITHOUT_PAYLOAD_INDEX = 9;	


        /// <summary>Value of the first start byte = 'R'</summary>
        public const byte RFE_START_BYTE_1 = 0x52;
        /// <summary>Value of the second start byte = 'F'</summary>
        public const byte RFE_START_BYTE_2 = 0x46;
        /// <summary>Value of the third start byte = 'E'</summary>
        public const byte RFE_START_BYTE_3 = 0x45;	
        /// <summary>Value of the command start byte</summary>
        public const byte RFE_COMMAND_START_BYTE = 0x01;
        /// <summary>Value of the length start byte</summary>
        public const byte RFE_LENGTH_START_BYTE = 0x02;	
        /// <summary>Value of the payload start byte</summary>
        public const byte RFE_PAYLOAD_START_BYTE = 0x03;	
        /// <summary>Value of the checksum start byte</summary>
        public const byte RFE_CHECKSUM_START_BYTE = 0x04;

        /// <summary>Identifier that says that the current inventory round ended</summary>
        public const byte RFE_INVENTORY_ROUND_ENDED = 0x00;
        /// <summary>Value of the tagId start byte in an inventory answer</summary>
        public const byte RFE_TAG_ID_START_BYTE = 0x01;
        /// <summary>Value of the rssi start byte in an inventory answer</summary>
        public const byte RFE_RSSI_START_BYTE = 0x02;
        /// <summary>Value of the user memory start byte in an inventory answer</summary>
        public const byte RFE_MEM_START_BYTE = 0x03;
        /// <summary>Value of the trigger start byte in an inventory answer</summary>
        public const byte RFE_TRIGGER_START_BYTE = 0x04;
        /// <summary>Value of the antenna id start byte in an inventory answer</summary>
        public const byte RFE_ANTENNA_ID_START_BYTE = 0x05;	
        /// <summary>Value of the frequency start byte in an inventory answer</summary>
        public const byte RFE_READ_FREQU_START_BYTE = 0x06;	
        /// <summary>Value of the handle in an inventory answer</summary>
        public const byte RFE_GEN2_HANDLE_START_BYTE = 0x07;
        /// <summary>Value of the state start byte in an inventory answer</summary>
        public const byte RFE_STATE_START_BYTE = 0x08;
        /// <summary>Value of the battery start byte in an inventory answer</summary>
        public const byte RFE_BATTERY_START_BYTE = 0x09;
        /// <summary>Value of the Gen2 PC in an inventory answer</summary>
        public const byte RFE_GEN2_PC_START_BYTE = 0x0A;
        /// <summary>Value of the message id in an inventory answer</summary>
        public const byte RFE_MESSAGE_ID_START_BYTE = 0x0B;
        /// <summary>Data from the application information</summary>
        public const byte RFE_APPLICATION_START_BYTE = 0x70;


        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_READER_COMMON = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_SERIAL_NUMBER = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_READER_TYPE = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_HARDWARE_REVISION = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_SOFTWARE_REVISION = 0x04;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_BOOTLOADER_REVISION = 0x05;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_CURRENT_SYSTEM = 0x06;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_CURRENT_STATE = 0x07;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_STATUS_REGISTER = 0x08;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_ANTENNA_COUNT = 0x10;

        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_READER_RF = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_ATTENUATION = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_FREQUENCY = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_SENSITIVITY = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_LBT_PARAMS = 0x04;
            /// <summary>Command definition, can be found in the protocol description</summary>
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_ATTENUATION = 0x81;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_FREQUENCY = 0x82;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_SENSITIVITY = 0x83;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_LBT_PARAMS = 0x84;

        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_READER_CONTROL = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_REBOOT = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_HEARTBEAT = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_ANTENNA_POWER = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_RESTORE_FACTORY_SETTINGS = 0x20;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SAVE_SETTINGS_PERMANENT = 0x21;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_PARAM = 0x30;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_PARAM = 0x31;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_DEVICE_NAME = 0x32;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_DEVICE_NAME = 0x33;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_DEVICE_LOCATION = 0x34;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_DEVICE_LOCATION = 0x35;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SWITCH_SYSTEM = 0xFE;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_BOOTLOADER_COMMAND = 0xFF;


        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_READER_TAG_MODE = 0x04;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_TAG_MODE = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_CURRENT_TAG_MODE = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_TAG_FUNCTION_LIST = 0x03;

        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_READER_GPIO = 0x05;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_GPIO_CAPS = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_GPIO_DIRECTION = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_GPIO_DIRECTION = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_GPIO = 0x04;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_GPIO = 0x05;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_CLEAR_GPIO = 0x06;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_CLEAR_SET_GPIO = 0x07;

        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_READER_ANTENNA = 0x06;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_ANTENNA_SEQUENCE = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_ANTENNA_SEQUENCE = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_SET_WORKING_ANTENNA = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_WORKING_ANTENNA = 0x04;


        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_NOTIFICATION = 0x10;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_ACTIVATE_NOTIFICATION = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_DEACTIVATE_NOTIFICATION = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GET_ACTIVE_NOTIFICATION = 0x03;

        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_TAG_FUNCTIONS = 0x50;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_INVENTORY_SINGLE = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_INVENTORY_CYCLIC = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_READ_FROM_TAG = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_WRITE_TO_TAG = 0x04;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_LOCK_TAG = 0x05;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_KILL_TAG = 0x06;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_CUSTOM_TAG_COMMAND = 0x10;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_READ_MULTIPLE_FROM_TAG = 0x20;

        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_APPLICATION = 0x70;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_APPLICATION_CALL = 0x01;

        /// <summary>Command definition, can be found in the protocol description</summary>
        public const byte RFE_COM1_INTERRUPT = 0x90;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_HEARTBEAT_INTERRUPT = 0x01;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_INVENTORY_CYCLIC_INTERRUPT = 0x02;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_STATE_CHANGED_INTERRUPT = 0x03;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_STATUS_REG_CHANGED_INTERRUPT = 0x04;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_BOOT_UP_FINISHED_INTERRUPT = 0x05;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_NOTIFICATION_INTERRUPT = 0x06;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_APPLICATION_INTERRUPT = 0x07;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_OPERATION_RESULT_INTERRUPT = 0x08;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_GPIO_PINS_CHANGED = 0x09;
            /// <summary>Command definition, can be found in the protocol description</summary>
            public const byte RFE_COM2_ERROR_OCCURED = 0xFF;

        /// <summary>Return codes of the request handler that are also sent to the host</summary>
        public enum eRFE_RET_VALUE
        {
            /// <summary>Only internal return code that means there is nothing to do</summary>
	        RFE_RET_NOTHING_TODO = -1,
            /// <summary>Operation was successfull</summary>
            RFE_RET_SUCCESS = 0x00,	
            /// <summary>Operation result not present, is sent after operation done</summary>
            RFE_RET_RESULT_PENDING = 0x01,
            /// <summary>Operation is not supported</summary>
            RFE_RET_ERR_OP_NOT_SUPPORTED = 0x50,
            /// <summary>An unknwon error occured</summary>
            RFE_RET_ERR_UNKOWN_ERR = 0x51,
            /// <summary>While executing operation an error occured</summary>
            RFE_RET_ERR_ON_EXEC_OP = 0x52,
            /// <summary>The write operation could not be performed</summary>
            RFE_RET_ERR_COULD_NOT_WRITE = 0x53,
            /// <summary>The param count of a request was wrong</summary>
            RFE_RET_ERR_WRONG_PARAM_COUNT = 0x54,
            /// <summary>A param of a request was wrong</summary>
            RFE_RET_ERR_WRONG_PARAM = 0x55,	
            /// <summary>Gen2 Error: Tag is not in the range of the reader</summary>
            RFE_RET_TMI_TAG_UNREACHABLE = 0xA0,	
            /// <summary>Gen2 Error: Memory overrun -> address does not exist</summary>
            RFE_RET_TMI_MEM_OVERRUN = 0xA1,	
            /// <summary>Gen2 Error: Memory of the tag is locked</summary>
            RFE_RET_TMI_MEM_LOCKED = 0xA2,
            /// <summary>Gen2 Error: The tag has too less power</summary>
            RFE_RET_TMI_INSUFFICIENT_POWER = 0xA3,	
            /// <summary>Gen2 Error: The tag's state was not taken to secured</summary>
            RFE_RET_TMI_WRONG_PASSWORD = 0xA4
        };

        /// <summary>Typedef for the current state</summary>
        public enum eRFE_CURRENT_READER_STATE
        {
            /// <summary>Idle state</summary>
	        RFE_STATE_IDLE	= 0x00,
            /// <summary>Rebooting state</summary>
            RFE_STATE_REBOOTING = 0x01,
            /// <summary>Scanning state</summary>
            RFE_STATE_SCANNING = 0x10,
            /// <summary>Writing state</summary>
            RFE_STATE_WRITING = 0x11,
            /// <summary>Reading state</summary>
            RFE_STATE_READING = 0x12,
        } ;


        /// <summary>Typedef for current system</summary>
        public enum eRFE_CURRENT_SYSTEM
        {
            /// <summary>Bootloader system</summary>
	        RFE_SYS_BOOTLOADER = 0x22,
            /// <summary>Firmware system</summary>
            RFE_SYS_FIRMWARE = 0xBB	
        } ;

        /// <summary>Typedef for current system</summary>
        public enum eRFE_ERR_CODE
        {
            /// <summary>Measured too high reflected power on selected port</summary>
	        RFE_ERR_TOO_HIGH_RFP = 0x01,
        };

        /// <summary>Typedef for heartbeat parameter</summary>
        public enum eRFE_HEARTBEAT_SIGNAL
        {
            /// <summary>Turns heartbeat off</summary>
            HEARTBEAT_OFF = 0x00,
            /// <summary>Turns heartbeat on</summary>
            HEARTBEAT_ON = 0x01,
            /// <summary>Turns heartbeat duplex on</summary>
            HEARTBEAT_DUPLEX = 0x02,
            /// <summary>Turns heartbeat with state on</summary>
            HEARTBEAT_STATE_ON = 0x03,
            /// <summary>Turns heartbeat duplex with state on</summary>
            HEARTBEAT_STATE_DUPLEX = 0x04
        } ;


        /// <summary>Typedef for antenna power parameter</summary>
        public enum eRFE_ANTENNA_POWER
        {
            /// <summary>Turns antenna power on</summary>
            ANTENNA_OFF = 0x00,
            /// <summary>Turns antenna power off</summary>
            ANTENNA_ON = 0x01
        } ;


        /// <summary>Typedef for tag types</summary>
        public enum eRFE_TAG_MODE
        {
            /// <summary>ISO 6B tags</summary>
            ISO_18000_6_B = 0x40,
            /// <summary>ISO 6C / Gen2 tags</summary>
            ISO_18000_6_C = 0x41,
            /// <summary>RFE active tags</summary>
            RFE_ACTIVE_01 = 0xC0,
            /// <summary>RFE active tags</summary>
            RFE_ACTIVE_02 = 0xC1
        } ;


        /// <summary>Typedef for cyclic inventory parameter</summary>
        public enum eRFE_INVENTORY_MODE
        {
            /// <summary>Turns cyclic inventory on</summary>
            INVENTORY_OFF = 0x00,
            /// <summary>Turns cyclic inventory off</summary>
            INVENTORY_ON = 0x01,
        } ;


        /// <summary>Typedef for the trigger sources</summary>
        public enum eRFE_TRIGGER_SOURCE
        {
            /// <summary>No trigger</summary>
            TRIGGER_NONE = 0x00,
            /// <summary>Button trigger</summary>
            TRIGGER_BUTTON = 0x01,
        } ;


        /// <summary>Message states for parsing incomming data</summary>
        public enum eMessageState
        {
            /// <summary>Start byte #1</summary>
            START_BYTE_1,
            /// <summary>Start byte #2</summary>
            START_BYTE_2,
            /// <summary>Start byte #3</summary>
            START_BYTE_3,
            /// <summary>Command start byte</summary>
            COMMAND_START_BYTE,
            /// <summary>Command byte #1</summary>
            COMMAND_1,
            /// <summary>Command byte #2</summary>
            COMMAND_2,
            /// <summary>Length start byte</summary>
            LENGTH_START_BYTE,
            /// <summary>Length byte</summary>
            LENGTH,
            /// <summary>Payload start byte</summary>
            PAYLOAD_START_BYTE,
            /// <summary>Paylod bytes</summary>
            PAYLOAD,
            /// <summary>Checksum start byte</summary>
            CHECKSUM_START_BYTE,
            /// <summary>Checksum</summary>
            CHECKSUM
        };

        /// <summary>The different satets for parsing cyclic inventory isr</summary>
        public enum eInventoryMessageState
        {
            /// <summary>Start byte</summary>
            START,
            /// <summary>Inventory end indicator</summary>
            INVENTORY_END_INDICATOR,
            /// <summary>Tag Id length</summary>
            TAGID_LENGTH,
            /// <summary>Tag Id</summary>
            TAGID,
            /// <summary>RSSI byte #1</summary>
            RSSI1,
            /// <summary>RSSI byte #2</summary>
            RSSI2,
            /// <summary>Mem bank</summary>
            MEM_BANK,
            /// <summary>Mem address byte #1</summary>
            MEM_ADDR1,
            /// <summary>Mem address byte #2</summary>
            MEM_ADDR2,
            /// <summary>Mem size</summary>
            MEM_SIZE,
            /// <summary>Mem data</summary>
            MEM_DATA,
            /// <summary>Trigger</summary>
            TRIGGER,
            /// <summary>Antenna</summary>
            ANTENNA,
            /// <summary>Frequency byte #1</summary>
            FREQUENCY1,
            /// <summary>Frequency byte #2</summary>
            FREQUENCY2,
            /// <summary>Frequency byte #3</summary>
            FREQUENCY3,
            /// <summary>Handle byte #1</summary>
            HANDLE1,
            /// <summary>Handle byte #2</summary>
            HANDLE2,
            /// <summary>State byte #1</summary>
            STATE1,
            /// <summary>State byte #2</summary>
            STATE2,
            /// <summary>Battery indicator</summary>
            BATTERY,
            /// <summary>PC byte #1</summary>
            PC1,
            /// <summary>PC byte #2</summary>
            PC2,
            /// <summary>Message ID indicator</summary>
            MESSAGE_ID,
            /// <summary>Application size indicator</summary>
            APPLICATION_SIZE,
            /// <summary>Application data indicator</summary>
            APPLICATION_DATA,
        };




    }
}